<!-- Parent: Arendusvahendid -->
<!-- Label: git -->
<!-- Label: cicd -->
<!-- Label: bitbucket -->
<!-- Label: bamboo -->
<!-- Label: sonarqube -->

# Versioonihaldus ja CI/CD tööriistad

![CI/CD Banner](../../assets/banner-development-tools.jpg)

!!! info
    Juhend SMIT versioonihalduse ja CI/CD tööriistade kasutamiseks lähtekoodi versioonihaldusel ja automatiseeritud ehitamisel. Suunatud arendajatele, devops inseneridele ja projektijuhteile.

<!-- Include: ac:toc -->

## 🔄 **CI/CD põhimõtted ja kontseptsioonid**

### Continuous Integration (CI)

- Koodihoidlasse saadetud muudatuste automaatne kompileerimine ja testimine
- Pidev koodi kvaliteedi jälgimine ja tagasiside
- Vähemalt korra päevas kesksesse repositooriumi saatmine
- Arendajate töö tulemuste omavaheline sobivuse kontroll

### Continuous Delivery (CD)

- Valmis pakendatud tarkvara automaatne väljastamine
- Testkeskkondade automaatne uuendamine
- Toodangusse paigaldus manuaalse heakskiiduga

### Continuous Deployment

- Täielikult automatiseeritud protsess toodanguni
- Nõuab väga kõrget automaatset kvaliteedikontrolli
- Sobib kõrge muudatussagedusega projektidele

## 📚 **Detailsed juhendid**

### Versioonihaldus ja standardid

- **[Git standardid](../02-development-guidelines/version-control-standards.md)** - versioonihalduse reeglid ja tavad
- **[Code review juhendid](../02-development-guidelines/code-review-guidelines.md)** - koodi ülevaatuse protsess
- **[CI/CD pipeline'ite seadistamise juhend](ci-cd-pipeline-standardization.md)** - ühtsed standardid
- **[Automaattestimine](../05-testing/automated-testing.md)** - testimise integreerimine

### Seotud juhendid

- **[Monitooring ja jälgitavus](monitoring-observability.md)** - jõudluse jälgimine
- **[Logimise nõuded](logging-requirements.md)** - struktureeritud logimine
- **[KKK ja vastused](../07-resources-support/qa.md)** - levinud küsimused
- **[Korduma kippuvad küsimused](../07-resources-support/qa.md)** - abi ja tugi

## 🛠️ **Tööriistade ülevaade**

### Bitbucket (Git repositooriumid)

**Juurdepääs**: [https://source.smit.sise](https://source.smit.sise)

**Kirjeldus:**
Bitbucket on SMIT-i peamine Git repositooriumiteenus koodihalduseks ja koostööks. See on CI/CD protsessi alguspunkt, kus arendajad saadavad oma koodi ja loovad pull request'e.

**Põhifunktsioonid:**

- **Git repositooriumid** - lähtekoodihaldus ja versioonihaldus
- **Pull request'id** - koodi ülevaatused ja koostöö
- **Branch strateegiad** - Git flow ja feature branch töövood
- **Integratsioonid** - Bamboo, Jira, SonarQube ühendused

**Kasutamise juhendid:**

- **Repositooriumi loomine** - projekti struktuuri standardid
- **Branch strateegia** - Git flow või GitHub flow kasutamine
- **Pull request protsess** - koodi ülevaatuse nõuded
- **Õigused** - ligipääsuõiguste haldamine meeskondade kaupa

**Integratsioonid:**

- **Bamboo** - automaatne ehitamine commit'ide põhjal
- **Jira** - issue tracking ja branch seosed
- **SonarQube** - koodi kvaliteedi mõõtmine PR'ides
- **IDE'd** - IntelliJ, VS Code, Cursor integratsioonid

### Bamboo (CI/CD automatiseerimine)

**Juurdepääs**: [https://build.smit.sise](https://build.smit.sise)

**Kirjeldus:**
Bamboo on SMIT-i keskne CI/CD platvorm automatiseeritud ehitamiseks ja "deployment'ideks". See on CI/CD protsessi süda, mis koordineerib kõiki automaatseid samme - koodi kompileerimist, testimist, kvaliteedi kontrolli ja paigaldamist.

**Põhifunktsioonid:**

- **Build plan'id** - automatiseeritud ehitamise konfiguratsioon
- **Deployment projektid** - keskkondadesse paigaldamine
- **Test automatiseerimine** - automaattestide käivitamine
- **Teavitused** - ehitustulemuste teavitused

**Pipeline'ite arhitektuur:**
Bamboo kasutab YAML- või Java-põhist konfiguratsiooni (Bamboo Specs), mis võimaldab "Infrastructure as Code" lähenemist. Iga pipeline sisaldab kohustuslikke samme. SMIT-is kasutame ainult YAML põhist varianti.

**Praktilised näited:**

- SMIT-i nõuetele vastav Bamboo deploy konfiguratsioon: ["Bookstore Backend Deploy"](https://source.smit.sise/projects/EXAMPLES/repos/bookstore-backend-deploy/browse)
- Korrektne ehitamine ja pakendamine: ["Bookstore Backend"](https://source.smit.sise/projects/EXAMPLES/repos/bookstore-backend/browse/bamboo-specs)

**Bamboo Specs referents**: [Bamboo Specs Reference 11.0.4](https://docs.atlassian.com/bamboo-specs-docs/11.0.4/)

```yaml
# bamboo-specs.yml näide
version: 2

plan:
  key: PROJ-BUILD
  name: Project Build Plan
  
stages:
  - name: Build and Test
    jobs:
      - name: Maven Build
        tasks:
          - checkout
          - maven:
              goals: clean compile test
          - test-parser:
              type: junit
              test-results: target/surefire-reports/*.xml
```

**Deployment projektid:**

- **Development** - arenduskeskkonna automaatne "deployment"
- **Test** - testimiskeskkonna kontrollitud "deployment"
- **Production** - tootmiskeskkonna manuaalselt kinnitatud "deployment"

**Integratsioonid:**

- **Bitbucket** - automaatne ehitamine commit/PR põhjal
- **SonarQube** - koodi kvaliteedi kontroll ehituses
- **Jira** - "deployment" info linkimine issue'dega
- **Teavitused** - RocketChat, email teavitused

### Artifactory (Artefaktide repositoorium)

**Juurdepääs**: [https://artifacts.smit.sise](https://artifacts.smit.sise)

**Kirjeldus:**
Artifactory on SMIT-i keskne artefaktide repositooriumiteenus, mis hoiab ehitatud artefakte, teeke ja sõltuvusi. See on CI/CD protsessi keskne hoidla, kus kõik valmiskomponendid säilitatakse ja jagatakse.

**Põhifunktsioonid:**

- **Maven repositoorium** - Java artefaktide hoidmine ja avaldamine
- **npm registry** - JavaScript/TypeScript pakettide haldamine
- **Docker registry** - konteinerite piltide hoidmine
- **Generic repositooriumid** - muude artefaktide hoidmine

**Repositooriumi tüübid:**

- **Local repositooriumid** - sisemiselt loodud artefaktid
- **Remote repositooriumid** - väliste repositooriumide cache
- **Virtual repositooriumid** - ühendatud repositooriumide vaated

**Integratsioonid:**

- **Bamboo** - automaatne artefakti publitseerimine ehituses
- **Maven/Gradle** - dependency resolution ja artefakti "deployment"
- **npm/yarn** - JavaScript pakettide haldamine
- **Docker** - container image registry

**Kohalik juhend:** vaata üksikasju ja seadistusnäiteid lehel [Artifactory](artifactory.md).

## 🔄 **Töövoog (Development Workflow)**

```plantuml
@startuml
title Development Workflow
scale max 2000 width

actor Dev as Dev
component Bitbucket
component Bamboo
component SonarQube
component Artifactory
component Deploy
component TestReports
component Renovate

Dev --> Bitbucket
Bitbucket --> Bamboo : commit/PR
Bamboo --> SonarQube : code analysis
Bamboo --> Artifactory : publish artifacts
SonarQube --> Deploy : quality gate
Artifactory --> Deploy : deploy artifacts
Bamboo --> TestReports : test results
Renovate --> Bitbucket : dependency PRs

package "Quality Gates" {
  [SonarQube]
  [TestReports]
}

package "Artifact Management" {
  [Artifactory]
}
@enduml
```

## 🚀 **Deployment strateegiad ja protsessid**

### Ülevaade deployment protsessidest

**Standardsed keskkonnad:** Development, Testing, Staging, Production

**Deployment tüübid:** Automaatne (DEV/TEST), manuaalne kinnitamine (STAGING), kontrollitud release (PRODUCTION)

## 📚 **Detailsemad juhendid ja ressursid**

### Kvaliteedi kontrollid

- **[SonarQube nõuded](sonarqube-requirements.md)** - kvaliteedi kontrollide detailsed standardid ja konfiguratsioon
- **[Tehnilise võla vähendamine](technical-debt-reduction.md)** - kvaliteedi parendamise strateegiad
- **[Renovate dependency management](renovate-dependency-management.md)** - sõltuvuste automaatne uuendamine
- **[SonarQube nõuded](sonarqube-requirements.md)** - koodi kvaliteedi kontrollid

### Deployment ja infrastruktuur

- **[CI/CD pipeline'ite seadistamise juhend](ci-cd-pipeline-standardization.md)** - deployment strateegiad ja mustrid
- **[Platvormi infrastruktuur](../03-platform-infrastructure/)** - keskkondade haldamine ja konfiguratsioon

### Välised viited

- **Bitbucket dokumentatsioon**: [Bitbucket User Guide](https://confluence.atlassian.com/bitbucket)
- **Bamboo dokumentatsioon**: [Bamboo User Guide](https://confluence.atlassian.com/bamboo)
- **Git parimad tavad**: [Git Guidelines](../02-development-guidelines/code-review-guidelines.md)

---

> **📝 Git-managed page:** This content is automatically synced from [IDP Documentation Repository](https://source.smit.sise/projects/IDP/repos/idp-docs/browse/04-development-tools/source-control-cicd.md). **Do not edit manually in Confluence** - all changes should be made in Git and will be automatically deployed.
